package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{AppRunnerResourceArn, ServiceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateServiceRequest(
    serviceName: ServiceName,
    sourceConfiguration: zio.aws.apprunner.model.SourceConfiguration,
    instanceConfiguration: Option[
      zio.aws.apprunner.model.InstanceConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.apprunner.model.Tag]] = None,
    encryptionConfiguration: Option[
      zio.aws.apprunner.model.EncryptionConfiguration
    ] = None,
    healthCheckConfiguration: Option[
      zio.aws.apprunner.model.HealthCheckConfiguration
    ] = None,
    autoScalingConfigurationArn: Option[AppRunnerResourceArn] = None,
    networkConfiguration: Option[zio.aws.apprunner.model.NetworkConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CreateServiceRequest
      .builder()
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .sourceConfiguration(sourceConfiguration.buildAwsValue())
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        healthCheckConfiguration.map(value => value.buildAwsValue())
      )(_.healthCheckConfiguration)
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CreateServiceRequest.ReadOnly =
    zio.aws.apprunner.model.CreateServiceRequest.wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CreateServiceRequest =
      zio.aws.apprunner.model.CreateServiceRequest(
        serviceName,
        sourceConfiguration.asEditable,
        instanceConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encryptionConfiguration.map(value => value.asEditable),
        healthCheckConfiguration.map(value => value.asEditable),
        autoScalingConfigurationArn.map(value => value),
        networkConfiguration.map(value => value.asEditable)
      )
    def serviceName: ServiceName
    def sourceConfiguration
        : zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    def instanceConfiguration
        : Option[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly]
    def tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]]
    def encryptionConfiguration
        : Option[zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly]
    def healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly]
    def autoScalingConfigurationArn: Option[AppRunnerResourceArn]
    def networkConfiguration
        : Option[zio.aws.apprunner.model.NetworkConfiguration.ReadOnly]
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
    def getSourceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    ] = ZIO.succeed(sourceConfiguration)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getHealthCheckConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckConfiguration",
      healthCheckConfiguration
    )
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CreateServiceRequest
  ) extends zio.aws.apprunner.model.CreateServiceRequest.ReadOnly {
    override val serviceName: ServiceName =
      zio.aws.apprunner.model.primitives.ServiceName(impl.serviceName())
    override val sourceConfiguration
        : zio.aws.apprunner.model.SourceConfiguration.ReadOnly =
      zio.aws.apprunner.model.SourceConfiguration
        .wrap(impl.sourceConfiguration())
    override val instanceConfiguration
        : Option[zio.aws.apprunner.model.InstanceConfiguration.ReadOnly] = scala
      .Option(impl.instanceConfiguration())
      .map(value => zio.aws.apprunner.model.InstanceConfiguration.wrap(value))
    override val tags: Option[List[zio.aws.apprunner.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apprunner.model.Tag.wrap(item)
          }.toList
        )
    override val encryptionConfiguration
        : Option[zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.apprunner.model.EncryptionConfiguration.wrap(value)
        )
    override val healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly] =
      scala
        .Option(impl.healthCheckConfiguration())
        .map(value =>
          zio.aws.apprunner.model.HealthCheckConfiguration.wrap(value)
        )
    override val autoScalingConfigurationArn: Option[AppRunnerResourceArn] =
      scala
        .Option(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val networkConfiguration
        : Option[zio.aws.apprunner.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.apprunner.model.NetworkConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CreateServiceRequest
  ): zio.aws.apprunner.model.CreateServiceRequest.ReadOnly = new Wrapper(impl)
}
