package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Integer,
  AutoScalingConfigurationName,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoScalingConfigurationSummary(
    autoScalingConfigurationArn: Option[AppRunnerResourceArn] = None,
    autoScalingConfigurationName: Option[AutoScalingConfigurationName] = None,
    autoScalingConfigurationRevision: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary = {
    import AutoScalingConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
      .builder()
      .optionallyWith(
        autoScalingConfigurationArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationArn)
      .optionallyWith(
        autoScalingConfigurationName.map(value =>
          AutoScalingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.autoScalingConfigurationName)
      .optionallyWith(
        autoScalingConfigurationRevision.map(value => value: java.lang.Integer)
      )(_.autoScalingConfigurationRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    zio.aws.apprunner.model.AutoScalingConfigurationSummary
      .wrap(buildAwsValue())
}
object AutoScalingConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AutoScalingConfigurationSummary =
      zio.aws.apprunner.model.AutoScalingConfigurationSummary(
        autoScalingConfigurationArn.map(value => value),
        autoScalingConfigurationName.map(value => value),
        autoScalingConfigurationRevision.map(value => value)
      )
    def autoScalingConfigurationArn: Option[AppRunnerResourceArn]
    def autoScalingConfigurationName: Option[AutoScalingConfigurationName]
    def autoScalingConfigurationRevision: Option[Integer]
    def getAutoScalingConfigurationArn
        : ZIO[Any, AwsError, AppRunnerResourceArn] = AwsError.unwrapOptionField(
      "autoScalingConfigurationArn",
      autoScalingConfigurationArn
    )
    def getAutoScalingConfigurationName
        : ZIO[Any, AwsError, AutoScalingConfigurationName] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationName",
        autoScalingConfigurationName
      )
    def getAutoScalingConfigurationRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "autoScalingConfigurationRevision",
        autoScalingConfigurationRevision
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ) extends zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly {
    override val autoScalingConfigurationArn: Option[AppRunnerResourceArn] =
      scala
        .Option(impl.autoScalingConfigurationArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val autoScalingConfigurationName
        : Option[AutoScalingConfigurationName] = scala
      .Option(impl.autoScalingConfigurationName())
      .map(value =>
        zio.aws.apprunner.model.primitives.AutoScalingConfigurationName(value)
      )
    override val autoScalingConfigurationRevision: Option[Integer] = scala
      .Option(impl.autoScalingConfigurationRevision())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary
  ): zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
