package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  ServiceId,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ServiceSummary(
    serviceName: Option[ServiceName] = None,
    serviceId: Option[ServiceId] = None,
    serviceArn: Option[AppRunnerResourceArn] = None,
    serviceUrl: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    status: Option[zio.aws.apprunner.model.ServiceStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ServiceSummary = {
    import ServiceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ServiceSummary
      .builder()
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        serviceArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.serviceArn)
      .optionallyWith(serviceUrl.map(value => value: java.lang.String))(
        _.serviceUrl
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ServiceSummary.ReadOnly =
    zio.aws.apprunner.model.ServiceSummary.wrap(buildAwsValue())
}
object ServiceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ServiceSummary =
      zio.aws.apprunner.model.ServiceSummary(
        serviceName.map(value => value),
        serviceId.map(value => value),
        serviceArn.map(value => value),
        serviceUrl.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        status.map(value => value)
      )
    def serviceName: Option[ServiceName]
    def serviceId: Option[ServiceId]
    def serviceArn: Option[AppRunnerResourceArn]
    def serviceUrl: Option[String]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def status: Option[zio.aws.apprunner.model.ServiceStatus]
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUrl", serviceUrl)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.apprunner.model.ServiceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ) extends zio.aws.apprunner.model.ServiceSummary.ReadOnly {
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.apprunner.model.primitives.ServiceName(value))
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value => zio.aws.apprunner.model.primitives.ServiceId(value))
    override val serviceArn: Option[AppRunnerResourceArn] = scala
      .Option(impl.serviceArn())
      .map(value =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
      )
    override val serviceUrl: Option[String] =
      scala.Option(impl.serviceUrl()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.apprunner.model.ServiceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.apprunner.model.ServiceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ServiceSummary
  ): zio.aws.apprunner.model.ServiceSummary.ReadOnly = new Wrapper(impl)
}
