package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{RoleArn, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthenticationConfiguration(
    connectionArn: Option[AppRunnerResourceArn] = None,
    accessRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration = {
    import AuthenticationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
      .builder()
      .optionallyWith(
        connectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .optionallyWith(
        accessRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.accessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly =
    zio.aws.apprunner.model.AuthenticationConfiguration.wrap(buildAwsValue())
}
object AuthenticationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.AuthenticationConfiguration =
      zio.aws.apprunner.model.AuthenticationConfiguration(
        connectionArn.map(value => value),
        accessRoleArn.map(value => value)
      )
    def connectionArn: Option[AppRunnerResourceArn]
    def accessRoleArn: Option[RoleArn]
    def getConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
    def getAccessRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("accessRoleArn", accessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ) extends zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly {
    override val connectionArn: Option[AppRunnerResourceArn] = scala
      .Option(impl.connectionArn())
      .map(value =>
        zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
      )
    override val accessRoleArn: Option[RoleArn] = scala
      .Option(impl.accessRoleArn())
      .map(value => zio.aws.apprunner.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration
  ): zio.aws.apprunner.model.AuthenticationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
