package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAutoScalingConfigurationRequest(
    autoScalingConfigurationArn: AppRunnerResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest = {
    import DeleteAutoScalingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest
      .builder()
      .autoScalingConfigurationArn(
        AppRunnerResourceArn.unwrap(
          autoScalingConfigurationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DeleteAutoScalingConfigurationRequest.ReadOnly =
    zio.aws.apprunner.model.DeleteAutoScalingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteAutoScalingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DeleteAutoScalingConfigurationRequest =
      zio.aws.apprunner.model
        .DeleteAutoScalingConfigurationRequest(autoScalingConfigurationArn)
    def autoScalingConfigurationArn: AppRunnerResourceArn
    def getAutoScalingConfigurationArn
        : ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(autoScalingConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest
  ) extends zio.aws.apprunner.model.DeleteAutoScalingConfigurationRequest.ReadOnly {
    override val autoScalingConfigurationArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.autoScalingConfigurationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest
  ): zio.aws.apprunner.model.DeleteAutoScalingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
