package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDeploymentResponse(operationId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse = {
    import StartDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse
      .builder()
      .operationId(UUID.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly =
    zio.aws.apprunner.model.StartDeploymentResponse.wrap(buildAwsValue())
}
object StartDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.StartDeploymentResponse =
      zio.aws.apprunner.model.StartDeploymentResponse(operationId)
    def operationId: UUID
    def getOperationId: ZIO[Any, Nothing, UUID] = ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse
  ) extends zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly {
    override val operationId: UUID =
      zio.aws.apprunner.model.primitives.UUID(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.StartDeploymentResponse
  ): zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
