package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  ServiceId,
  ServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Service(
    serviceName: ServiceName,
    serviceId: ServiceId,
    serviceArn: AppRunnerResourceArn,
    serviceUrl: String,
    createdAt: Timestamp,
    updatedAt: Timestamp,
    deletedAt: Option[Timestamp] = None,
    status: zio.aws.apprunner.model.ServiceStatus,
    sourceConfiguration: zio.aws.apprunner.model.SourceConfiguration,
    instanceConfiguration: zio.aws.apprunner.model.InstanceConfiguration,
    encryptionConfiguration: Option[
      zio.aws.apprunner.model.EncryptionConfiguration
    ] = None,
    healthCheckConfiguration: Option[
      zio.aws.apprunner.model.HealthCheckConfiguration
    ] = None,
    autoScalingConfigurationSummary: zio.aws.apprunner.model.AutoScalingConfigurationSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.Service
      .builder()
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .serviceId(ServiceId.unwrap(serviceId): java.lang.String)
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .serviceUrl(serviceUrl: java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .optionallyWith(deletedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.deletedAt
      )
      .status(status.unwrap)
      .sourceConfiguration(sourceConfiguration.buildAwsValue())
      .instanceConfiguration(instanceConfiguration.buildAwsValue())
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        healthCheckConfiguration.map(value => value.buildAwsValue())
      )(_.healthCheckConfiguration)
      .autoScalingConfigurationSummary(
        autoScalingConfigurationSummary.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.Service.ReadOnly =
    zio.aws.apprunner.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.apprunner.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.Service =
      zio.aws.apprunner.model.Service(
        serviceName,
        serviceId,
        serviceArn,
        serviceUrl,
        createdAt,
        updatedAt,
        deletedAt.map(value => value),
        status,
        sourceConfiguration.asEditable,
        instanceConfiguration.asEditable,
        encryptionConfiguration.map(value => value.asEditable),
        healthCheckConfiguration.map(value => value.asEditable),
        autoScalingConfigurationSummary.asEditable
      )
    def serviceName: ServiceName
    def serviceId: ServiceId
    def serviceArn: AppRunnerResourceArn
    def serviceUrl: String
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def deletedAt: Option[Timestamp]
    def status: zio.aws.apprunner.model.ServiceStatus
    def sourceConfiguration
        : zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    def instanceConfiguration
        : zio.aws.apprunner.model.InstanceConfiguration.ReadOnly
    def encryptionConfiguration
        : Option[zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly]
    def healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly]
    def autoScalingConfigurationSummary
        : zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
    def getServiceId: ZIO[Any, Nothing, ServiceId] = ZIO.succeed(serviceId)
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getServiceUrl: ZIO[Any, Nothing, String] = ZIO.succeed(serviceUrl)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getDeletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deletedAt", deletedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.apprunner.model.ServiceStatus] =
      ZIO.succeed(status)
    def getSourceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.SourceConfiguration.ReadOnly
    ] = ZIO.succeed(sourceConfiguration)
    def getInstanceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.InstanceConfiguration.ReadOnly
    ] = ZIO.succeed(instanceConfiguration)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getHealthCheckConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "healthCheckConfiguration",
      healthCheckConfiguration
    )
    def getAutoScalingConfigurationSummary: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
    ] = ZIO.succeed(autoScalingConfigurationSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.Service
  ) extends zio.aws.apprunner.model.Service.ReadOnly {
    override val serviceName: ServiceName =
      zio.aws.apprunner.model.primitives.ServiceName(impl.serviceName())
    override val serviceId: ServiceId =
      zio.aws.apprunner.model.primitives.ServiceId(impl.serviceId())
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val serviceUrl: String = impl.serviceUrl(): String
    override val createdAt: Timestamp =
      zio.aws.apprunner.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.apprunner.model.primitives.Timestamp(impl.updatedAt())
    override val deletedAt: Option[Timestamp] = scala
      .Option(impl.deletedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val status: zio.aws.apprunner.model.ServiceStatus =
      zio.aws.apprunner.model.ServiceStatus.wrap(impl.status())
    override val sourceConfiguration
        : zio.aws.apprunner.model.SourceConfiguration.ReadOnly =
      zio.aws.apprunner.model.SourceConfiguration
        .wrap(impl.sourceConfiguration())
    override val instanceConfiguration
        : zio.aws.apprunner.model.InstanceConfiguration.ReadOnly =
      zio.aws.apprunner.model.InstanceConfiguration
        .wrap(impl.instanceConfiguration())
    override val encryptionConfiguration
        : Option[zio.aws.apprunner.model.EncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.encryptionConfiguration())
        .map(value =>
          zio.aws.apprunner.model.EncryptionConfiguration.wrap(value)
        )
    override val healthCheckConfiguration
        : Option[zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly] =
      scala
        .Option(impl.healthCheckConfiguration())
        .map(value =>
          zio.aws.apprunner.model.HealthCheckConfiguration.wrap(value)
        )
    override val autoScalingConfigurationSummary
        : zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly =
      zio.aws.apprunner.model.AutoScalingConfigurationSummary
        .wrap(impl.autoScalingConfigurationSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.Service
  ): zio.aws.apprunner.model.Service.ReadOnly = new Wrapper(impl)
}
