package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{NullableBoolean, DomainName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomDomain(
    domainName: DomainName,
    enableWWWSubdomain: NullableBoolean,
    certificateValidationRecords: Option[
      Iterable[zio.aws.apprunner.model.CertificateValidationRecord]
    ] = None,
    status: zio.aws.apprunner.model.CustomDomainAssociationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.CustomDomain = {
    import CustomDomain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.CustomDomain
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .enableWWWSubdomain(
        NullableBoolean.unwrap(enableWWWSubdomain): java.lang.Boolean
      )
      .optionallyWith(
        certificateValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificateValidationRecords)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.CustomDomain.ReadOnly =
    zio.aws.apprunner.model.CustomDomain.wrap(buildAwsValue())
}
object CustomDomain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.CustomDomain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.CustomDomain =
      zio.aws.apprunner.model.CustomDomain(
        domainName,
        enableWWWSubdomain,
        certificateValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status
      )
    def domainName: DomainName
    def enableWWWSubdomain: NullableBoolean
    def certificateValidationRecords: Option[
      List[zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly]
    ]
    def status: zio.aws.apprunner.model.CustomDomainAssociationStatus
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getEnableWWWSubdomain: ZIO[Any, Nothing, NullableBoolean] =
      ZIO.succeed(enableWWWSubdomain)
    def getCertificateValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "certificateValidationRecords",
      certificateValidationRecords
    )
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.CustomDomainAssociationStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.CustomDomain
  ) extends zio.aws.apprunner.model.CustomDomain.ReadOnly {
    override val domainName: DomainName =
      zio.aws.apprunner.model.primitives.DomainName(impl.domainName())
    override val enableWWWSubdomain: NullableBoolean =
      zio.aws.apprunner.model.primitives
        .NullableBoolean(impl.enableWWWSubdomain())
    override val certificateValidationRecords: Option[
      List[zio.aws.apprunner.model.CertificateValidationRecord.ReadOnly]
    ] = scala
      .Option(impl.certificateValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apprunner.model.CertificateValidationRecord.wrap(item)
        }.toList
      )
    override val status: zio.aws.apprunner.model.CustomDomainAssociationStatus =
      zio.aws.apprunner.model.CustomDomainAssociationStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.CustomDomain
  ): zio.aws.apprunner.model.CustomDomain.ReadOnly = new Wrapper(impl)
}
