package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.{
  ListOperationsMaxResults,
  AppRunnerResourceArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOperationsRequest(
    serviceArn: AppRunnerResourceArn,
    nextToken: Option[String] = None,
    maxResults: Option[ListOperationsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.ListOperationsRequest = {
    import ListOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
      .builder()
      .serviceArn(AppRunnerResourceArn.unwrap(serviceArn): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ListOperationsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.ListOperationsRequest.ReadOnly =
    zio.aws.apprunner.model.ListOperationsRequest.wrap(buildAwsValue())
}
object ListOperationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.ListOperationsRequest =
      zio.aws.apprunner.model.ListOperationsRequest(
        serviceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def serviceArn: AppRunnerResourceArn
    def nextToken: Option[String]
    def maxResults: Option[ListOperationsMaxResults]
    def getServiceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(serviceArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListOperationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ) extends zio.aws.apprunner.model.ListOperationsRequest.ReadOnly {
    override val serviceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives.AppRunnerResourceArn(impl.serviceArn())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[ListOperationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.apprunner.model.primitives.ListOperationsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.ListOperationsRequest
  ): zio.aws.apprunner.model.ListOperationsRequest.ReadOnly = new Wrapper(impl)
}
