package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait ImageRepositoryType {
  def unwrap
      : software.amazon.awssdk.services.apprunner.model.ImageRepositoryType
}
object ImageRepositoryType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.ImageRepositoryType
  ): zio.aws.apprunner.model.ImageRepositoryType = value match {
    case software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.ECR =>
      val r = ECR
      r
    case software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.ECR_PUBLIC =>
      val r = ECR_PUBLIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.ImageRepositoryType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ImageRepositoryType =
      software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.UNKNOWN_TO_SDK_VERSION
  }
  case object ECR extends zio.aws.apprunner.model.ImageRepositoryType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ImageRepositoryType =
      software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.ECR
  }
  case object ECR_PUBLIC extends zio.aws.apprunner.model.ImageRepositoryType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.ImageRepositoryType =
      software.amazon.awssdk.services.apprunner.model.ImageRepositoryType.ECR_PUBLIC
  }
}
