package zio.aws.apprunner
import zio.aws.apprunner.model.DescribeCustomDomainsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.apprunner.model.{
  CreateObservabilityConfigurationRequest,
  DescribeVpcConnectorRequest,
  StartDeploymentRequest,
  DeleteServiceRequest,
  CreateConnectionRequest,
  CreateAutoScalingConfigurationRequest,
  ListVpcConnectorsRequest,
  ListTagsForResourceRequest,
  CreateVpcConnectorRequest,
  DeleteVpcConnectorRequest,
  DisassociateCustomDomainRequest,
  ListAutoScalingConfigurationsRequest,
  DeleteConnectionRequest,
  CreateServiceRequest,
  DeleteObservabilityConfigurationRequest,
  DescribeCustomDomainsRequest,
  DescribeServiceRequest,
  AssociateCustomDomainRequest,
  PauseServiceRequest,
  UntagResourceRequest,
  DescribeAutoScalingConfigurationRequest,
  DeleteAutoScalingConfigurationRequest,
  ListServicesRequest,
  ListConnectionsRequest,
  ListObservabilityConfigurationsRequest,
  UpdateServiceRequest,
  ResumeServiceRequest,
  ListOperationsRequest,
  TagResourceRequest,
  DescribeObservabilityConfigurationRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.apprunner.{
  AppRunnerAsyncClientBuilder,
  AppRunnerAsyncClient
}
import software.amazon.awssdk.services.apprunner.model.{
  ListConnectionsResponse,
  DeleteConnectionResponse,
  ObservabilityConfigurationSummary,
  DescribeServiceResponse,
  ResumeServiceResponse,
  DeleteAutoScalingConfigurationResponse,
  CreateConnectionResponse,
  CreateObservabilityConfigurationResponse,
  DeleteVpcConnectorResponse,
  ServiceSummary,
  UpdateServiceResponse,
  AssociateCustomDomainResponse,
  ListAutoScalingConfigurationsResponse,
  CreateServiceResponse,
  DeleteServiceResponse,
  DescribeAutoScalingConfigurationResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeCustomDomainsResponse,
  VpcConnector,
  DisassociateCustomDomainResponse,
  ListVpcConnectorsResponse,
  ListOperationsResponse,
  ListObservabilityConfigurationsResponse,
  AutoScalingConfigurationSummary,
  DescribeVpcConnectorResponse,
  DescribeObservabilityConfigurationResponse,
  OperationSummary,
  StartDeploymentResponse,
  DeleteObservabilityConfigurationResponse,
  CreateVpcConnectorResponse,
  TagResourceResponse,
  PauseServiceResponse,
  ConnectionSummary,
  CreateAutoScalingConfigurationResponse,
  CustomDomain,
  ListServicesResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AppRunner extends AspectSupport[AppRunner] {
  val api: AppRunnerAsyncClient
  def listVpcConnectors(
      request: ListVpcConnectorsRequest
  ): ZStream[Any, AwsError, zio.aws.apprunner.model.VpcConnector.ReadOnly]
  def listVpcConnectorsPaginated(
      request: ListVpcConnectorsRequest
  ): IO[AwsError, zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly]
  def describeVpcConnector(
      request: DescribeVpcConnectorRequest
  ): IO[AwsError, zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly]
  def resumeService(
      request: ResumeServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly]
  def associateCustomDomain(request: AssociateCustomDomainRequest): IO[
    AwsError,
    zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
  ]
  def createService(
      request: CreateServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.CreateServiceResponse.ReadOnly]
  def createVpcConnector(
      request: CreateVpcConnectorRequest
  ): IO[AwsError, zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly]
  def createConnection(
      request: CreateConnectionRequest
  ): IO[AwsError, zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly]
  def createAutoScalingConfiguration(
      request: CreateAutoScalingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
  ]
  def deleteService(
      request: DeleteServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly]
  def listServices(
      request: ListServicesRequest
  ): ZStream[Any, AwsError, zio.aws.apprunner.model.ServiceSummary.ReadOnly]
  def listServicesPaginated(
      request: ListServicesRequest
  ): IO[AwsError, zio.aws.apprunner.model.ListServicesResponse.ReadOnly]
  def describeCustomDomains(
      request: DescribeCustomDomainsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    ReadOnly,
    zio.aws.apprunner.model.CustomDomain.ReadOnly
  ]]
  def describeCustomDomainsPaginated(
      request: DescribeCustomDomainsRequest
  ): IO[AwsError, ReadOnly]
  def listConnections(
      request: ListConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.apprunner.model.ConnectionSummary.ReadOnly]
  def listConnectionsPaginated(
      request: ListConnectionsRequest
  ): IO[AwsError, zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly]
  def listOperations(
      request: ListOperationsRequest
  ): ZStream[Any, AwsError, zio.aws.apprunner.model.OperationSummary.ReadOnly]
  def listOperationsPaginated(
      request: ListOperationsRequest
  ): IO[AwsError, zio.aws.apprunner.model.ListOperationsResponse.ReadOnly]
  def deleteAutoScalingConfiguration(
      request: DeleteAutoScalingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
  ]
  def deleteObservabilityConfiguration(
      request: DeleteObservabilityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
  ]
  def pauseService(
      request: PauseServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.PauseServiceResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.apprunner.model.UntagResourceResponse.ReadOnly]
  def listAutoScalingConfigurations(
      request: ListAutoScalingConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
  ]
  def listAutoScalingConfigurationsPaginated(
      request: ListAutoScalingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly]
  def deleteConnection(
      request: DeleteConnectionRequest
  ): IO[AwsError, zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.apprunner.model.TagResourceResponse.ReadOnly]
  def updateService(
      request: UpdateServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly]
  def listObservabilityConfigurations(
      request: ListObservabilityConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
  ]
  def listObservabilityConfigurationsPaginated(
      request: ListObservabilityConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
  ]
  def disassociateCustomDomain(request: DisassociateCustomDomainRequest): IO[
    AwsError,
    zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
  ]
  def createObservabilityConfiguration(
      request: CreateObservabilityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
  ]
  def deleteVpcConnector(
      request: DeleteVpcConnectorRequest
  ): IO[AwsError, zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly]
  def describeService(
      request: DescribeServiceRequest
  ): IO[AwsError, zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly]
  def describeAutoScalingConfiguration(
      request: DescribeAutoScalingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
  ]
  def startDeployment(
      request: StartDeploymentRequest
  ): IO[AwsError, zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly]
  def describeObservabilityConfiguration(
      request: DescribeObservabilityConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
  ]
}
object AppRunner {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppRunner] = customized(
    identity
  )
  def customized(
      customization: AppRunnerAsyncClientBuilder => AppRunnerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppRunner] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AppRunnerAsyncClientBuilder => AppRunnerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AppRunner] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AppRunnerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppRunnerAsyncClient, AppRunnerAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[AppRunnerAsyncClient, AppRunnerAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AppRunnerImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppRunnerImpl[R](
      override val api: AppRunnerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppRunner
      with AwsServiceBase[R] {
    override val serviceName: String = "AppRunner"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppRunnerImpl[R1] = new AppRunnerImpl(api, newAspect, r)
    def listVpcConnectors(request: ListVpcConnectorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.apprunner.model.VpcConnector.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsRequest,
      ListVpcConnectorsResponse,
      VpcConnector
    ](
      "listVpcConnectors",
      api.listVpcConnectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpcConnectors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.apprunner.model.VpcConnector.wrap(item))
      .provideEnvironment(r)
    def listVpcConnectorsPaginated(request: ListVpcConnectorsRequest): IO[
      AwsError,
      zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsRequest,
      ListVpcConnectorsResponse
    ]("listVpcConnectors", api.listVpcConnectors)(request.buildAwsValue())
      .map(zio.aws.apprunner.model.ListVpcConnectorsResponse.wrap)
      .provideEnvironment(r)
    def describeVpcConnector(request: DescribeVpcConnectorRequest): IO[
      AwsError,
      zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DescribeVpcConnectorRequest,
      DescribeVpcConnectorResponse
    ]("describeVpcConnector", api.describeVpcConnector)(request.buildAwsValue())
      .map(zio.aws.apprunner.model.DescribeVpcConnectorResponse.wrap)
      .provideEnvironment(r)
    def resumeService(
        request: ResumeServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.ResumeServiceRequest,
        ResumeServiceResponse
      ]("resumeService", api.resumeService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.ResumeServiceResponse.wrap)
        .provideEnvironment(r)
    def associateCustomDomain(request: AssociateCustomDomainRequest): IO[
      AwsError,
      zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.AssociateCustomDomainRequest,
      AssociateCustomDomainResponse
    ]("associateCustomDomain", api.associateCustomDomain)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.AssociateCustomDomainResponse.wrap)
      .provideEnvironment(r)
    def createService(
        request: CreateServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.CreateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.CreateServiceRequest,
        CreateServiceResponse
      ]("createService", api.createService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.CreateServiceResponse.wrap)
        .provideEnvironment(r)
    def createVpcConnector(request: CreateVpcConnectorRequest): IO[
      AwsError,
      zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.CreateVpcConnectorRequest,
      CreateVpcConnectorResponse
    ]("createVpcConnector", api.createVpcConnector)(request.buildAwsValue())
      .map(zio.aws.apprunner.model.CreateVpcConnectorResponse.wrap)
      .provideEnvironment(r)
    def createConnection(
        request: CreateConnectionRequest
    ): IO[AwsError, zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.CreateConnectionRequest,
        CreateConnectionResponse
      ]("createConnection", api.createConnection)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.CreateConnectionResponse.wrap)
        .provideEnvironment(r)
    def createAutoScalingConfiguration(
        request: CreateAutoScalingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.CreateAutoScalingConfigurationRequest,
      CreateAutoScalingConfigurationResponse
    ]("createAutoScalingConfiguration", api.createAutoScalingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteService(
        request: DeleteServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.DeleteServiceRequest,
        DeleteServiceResponse
      ]("deleteService", api.deleteService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.DeleteServiceResponse.wrap)
        .provideEnvironment(r)
    def listServices(
        request: ListServicesRequest
    ): ZStream[Any, AwsError, zio.aws.apprunner.model.ServiceSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.apprunner.model.ListServicesRequest,
        ListServicesResponse,
        ServiceSummary
      ](
        "listServices",
        api.listServices,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.serviceSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apprunner.model.ServiceSummary.wrap(item))
        .provideEnvironment(r)
    def listServicesPaginated(
        request: ListServicesRequest
    ): IO[AwsError, zio.aws.apprunner.model.ListServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.ListServicesRequest,
        ListServicesResponse
      ]("listServices", api.listServices)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.ListServicesResponse.wrap)
        .provideEnvironment(r)
    def describeCustomDomains(
        request: DescribeCustomDomainsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      ReadOnly,
      zio.aws.apprunner.model.CustomDomain.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest,
      DescribeCustomDomainsResponse,
      CustomDomain
    ](
      "describeCustomDomains",
      api.describeCustomDomains,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.customDomains().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.apprunner.model.DescribeCustomDomainsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.apprunner.model.CustomDomain.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeCustomDomainsPaginated(
        request: DescribeCustomDomainsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DescribeCustomDomainsRequest,
      DescribeCustomDomainsResponse
    ]("describeCustomDomains", api.describeCustomDomains)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.DescribeCustomDomainsResponse.wrap)
      .provideEnvironment(r)
    def listConnections(request: ListConnectionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.apprunner.model.ConnectionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest,
      ListConnectionsResponse,
      ConnectionSummary
    ](
      "listConnections",
      api.listConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectionSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.apprunner.model.ConnectionSummary.wrap(item))
      .provideEnvironment(r)
    def listConnectionsPaginated(
        request: ListConnectionsRequest
    ): IO[AwsError, zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest,
        ListConnectionsResponse
      ]("listConnections", api.listConnections)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.ListConnectionsResponse.wrap)
        .provideEnvironment(r)
    def listOperations(request: ListOperationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.apprunner.model.OperationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.ListOperationsRequest,
      ListOperationsResponse,
      OperationSummary
    ](
      "listOperations",
      api.listOperations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.operationSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.apprunner.model.OperationSummary.wrap(item))
      .provideEnvironment(r)
    def listOperationsPaginated(
        request: ListOperationsRequest
    ): IO[AwsError, zio.aws.apprunner.model.ListOperationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.ListOperationsRequest,
        ListOperationsResponse
      ]("listOperations", api.listOperations)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.ListOperationsResponse.wrap)
        .provideEnvironment(r)
    def deleteAutoScalingConfiguration(
        request: DeleteAutoScalingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DeleteAutoScalingConfigurationRequest,
      DeleteAutoScalingConfigurationResponse
    ]("deleteAutoScalingConfiguration", api.deleteAutoScalingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteObservabilityConfiguration(
        request: DeleteObservabilityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DeleteObservabilityConfigurationRequest,
      DeleteObservabilityConfigurationResponse
    ]("deleteObservabilityConfiguration", api.deleteObservabilityConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.wrap)
      .provideEnvironment(r)
    def pauseService(
        request: PauseServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.PauseServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.PauseServiceRequest,
        PauseServiceResponse
      ]("pauseService", api.pauseService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.PauseServiceResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.apprunner.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listAutoScalingConfigurations(
        request: ListAutoScalingConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest,
      ListAutoScalingConfigurationsResponse,
      AutoScalingConfigurationSummary
    ](
      "listAutoScalingConfigurations",
      api.listAutoScalingConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.autoScalingConfigurationSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.apprunner.model.AutoScalingConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listAutoScalingConfigurationsPaginated(
        request: ListAutoScalingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.ListAutoScalingConfigurationsRequest,
      ListAutoScalingConfigurationsResponse
    ]("listAutoScalingConfigurations", api.listAutoScalingConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.apprunner.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteConnection(
        request: DeleteConnectionRequest
    ): IO[AwsError, zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.DeleteConnectionRequest,
        DeleteConnectionResponse
      ]("deleteConnection", api.deleteConnection)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.DeleteConnectionResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.apprunner.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateService(
        request: UpdateServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.UpdateServiceRequest,
        UpdateServiceResponse
      ]("updateService", api.updateService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.UpdateServiceResponse.wrap)
        .provideEnvironment(r)
    def listObservabilityConfigurations(
        request: ListObservabilityConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest,
      ListObservabilityConfigurationsResponse,
      ObservabilityConfigurationSummary
    ](
      "listObservabilityConfigurations",
      api.listObservabilityConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.observabilityConfigurationSummaryList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.apprunner.model.ObservabilityConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listObservabilityConfigurationsPaginated(
        request: ListObservabilityConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest,
      ListObservabilityConfigurationsResponse
    ]("listObservabilityConfigurations", api.listObservabilityConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def disassociateCustomDomain(request: DisassociateCustomDomainRequest): IO[
      AwsError,
      zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DisassociateCustomDomainRequest,
      DisassociateCustomDomainResponse
    ]("disassociateCustomDomain", api.disassociateCustomDomain)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.DisassociateCustomDomainResponse.wrap)
      .provideEnvironment(r)
    def createObservabilityConfiguration(
        request: CreateObservabilityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.CreateObservabilityConfigurationRequest,
      CreateObservabilityConfigurationResponse
    ]("createObservabilityConfiguration", api.createObservabilityConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcConnector(request: DeleteVpcConnectorRequest): IO[
      AwsError,
      zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DeleteVpcConnectorRequest,
      DeleteVpcConnectorResponse
    ]("deleteVpcConnector", api.deleteVpcConnector)(request.buildAwsValue())
      .map(zio.aws.apprunner.model.DeleteVpcConnectorResponse.wrap)
      .provideEnvironment(r)
    def describeService(
        request: DescribeServiceRequest
    ): IO[AwsError, zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.DescribeServiceRequest,
        DescribeServiceResponse
      ]("describeService", api.describeService)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.DescribeServiceResponse.wrap)
        .provideEnvironment(r)
    def describeAutoScalingConfiguration(
        request: DescribeAutoScalingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DescribeAutoScalingConfigurationRequest,
      DescribeAutoScalingConfigurationResponse
    ]("describeAutoScalingConfiguration", api.describeAutoScalingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def startDeployment(
        request: StartDeploymentRequest
    ): IO[AwsError, zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.apprunner.model.StartDeploymentRequest,
        StartDeploymentResponse
      ]("startDeployment", api.startDeployment)(request.buildAwsValue())
        .map(zio.aws.apprunner.model.StartDeploymentResponse.wrap)
        .provideEnvironment(r)
    def describeObservabilityConfiguration(
        request: DescribeObservabilityConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.apprunner.model.DescribeObservabilityConfigurationRequest,
      DescribeObservabilityConfigurationResponse
    ](
      "describeObservabilityConfiguration",
      api.describeObservabilityConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def listVpcConnectors(request: ListVpcConnectorsRequest): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.VpcConnector.ReadOnly
  ] = ZStream.serviceWithStream(_.listVpcConnectors(request))
  def listVpcConnectorsPaginated(request: ListVpcConnectorsRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListVpcConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcConnectorsPaginated(request))
  def describeVpcConnector(request: DescribeVpcConnectorRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DescribeVpcConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcConnector(request))
  def resumeService(request: ResumeServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ResumeServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resumeService(request))
  def associateCustomDomain(request: AssociateCustomDomainRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.AssociateCustomDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateCustomDomain(request))
  def createService(request: CreateServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.CreateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createService(request))
  def createVpcConnector(request: CreateVpcConnectorRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.CreateVpcConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcConnector(request))
  def createConnection(request: CreateConnectionRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.CreateConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnection(request))
  def createAutoScalingConfiguration(
      request: CreateAutoScalingConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.CreateAutoScalingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAutoScalingConfiguration(request))
  def deleteService(request: DeleteServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteService(request))
  def listServices(request: ListServicesRequest): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ServiceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(request: ListServicesRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def describeCustomDomains(
      request: DescribeCustomDomainsRequest
  ): ZIO[zio.aws.apprunner.AppRunner, AwsError, StreamingOutputResult[
    Any,
    ReadOnly,
    zio.aws.apprunner.model.CustomDomain.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeCustomDomains(request))
  def describeCustomDomainsPaginated(
      request: DescribeCustomDomainsRequest
  ): ZIO[zio.aws.apprunner.AppRunner, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeCustomDomainsPaginated(request))
  def listConnections(request: ListConnectionsRequest): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ConnectionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnections(request))
  def listConnectionsPaginated(request: ListConnectionsRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectionsPaginated(request))
  def listOperations(request: ListOperationsRequest): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.OperationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listOperations(request))
  def listOperationsPaginated(request: ListOperationsRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListOperationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOperationsPaginated(request))
  def deleteAutoScalingConfiguration(
      request: DeleteAutoScalingConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DeleteAutoScalingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAutoScalingConfiguration(request))
  def deleteObservabilityConfiguration(
      request: DeleteObservabilityConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DeleteObservabilityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObservabilityConfiguration(request))
  def pauseService(request: PauseServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.PauseServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.pauseService(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listAutoScalingConfigurations(
      request: ListAutoScalingConfigurationsRequest
  ): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.AutoScalingConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAutoScalingConfigurations(request))
  def listAutoScalingConfigurationsPaginated(
      request: ListAutoScalingConfigurationsRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListAutoScalingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAutoScalingConfigurationsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteConnection(request: DeleteConnectionRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateService(request: UpdateServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.UpdateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateService(request))
  def listObservabilityConfigurations(
      request: ListObservabilityConfigurationsRequest
  ): ZStream[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ObservabilityConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listObservabilityConfigurations(request))
  def listObservabilityConfigurationsPaginated(
      request: ListObservabilityConfigurationsRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.ListObservabilityConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObservabilityConfigurationsPaginated(request))
  def disassociateCustomDomain(request: DisassociateCustomDomainRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DisassociateCustomDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateCustomDomain(request))
  def createObservabilityConfiguration(
      request: CreateObservabilityConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.CreateObservabilityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createObservabilityConfiguration(request))
  def deleteVpcConnector(request: DeleteVpcConnectorRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DeleteVpcConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcConnector(request))
  def describeService(request: DescribeServiceRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DescribeServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeService(request))
  def describeAutoScalingConfiguration(
      request: DescribeAutoScalingConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DescribeAutoScalingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAutoScalingConfiguration(request))
  def startDeployment(request: StartDeploymentRequest): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.StartDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeployment(request))
  def describeObservabilityConfiguration(
      request: DescribeObservabilityConfigurationRequest
  ): ZIO[
    zio.aws.apprunner.AppRunner,
    AwsError,
    zio.aws.apprunner.model.DescribeObservabilityConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeObservabilityConfiguration(request))
}
