package zio.aws.apprunner.model
import java.lang.Integer
import zio.aws.apprunner.model.primitives.{
  HealthCheckInterval,
  HealthCheckPath,
  HealthCheckHealthyThreshold,
  HealthCheckTimeout,
  HealthCheckUnhealthyThreshold
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HealthCheckConfiguration(
    protocol: Option[zio.aws.apprunner.model.HealthCheckProtocol] = None,
    path: Option[HealthCheckPath] = None,
    interval: Option[HealthCheckInterval] = None,
    timeout: Option[HealthCheckTimeout] = None,
    healthyThreshold: Option[HealthCheckHealthyThreshold] = None,
    unhealthyThreshold: Option[HealthCheckUnhealthyThreshold] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration = {
    import HealthCheckConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        path.map(value => HealthCheckPath.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        interval.map(value => HealthCheckInterval.unwrap(value): Integer)
      )(_.interval)
      .optionallyWith(
        timeout.map(value => HealthCheckTimeout.unwrap(value): Integer)
      )(_.timeout)
      .optionallyWith(
        healthyThreshold.map(value =>
          HealthCheckHealthyThreshold.unwrap(value): Integer
        )
      )(_.healthyThreshold)
      .optionallyWith(
        unhealthyThreshold.map(value =>
          HealthCheckUnhealthyThreshold.unwrap(value): Integer
        )
      )(_.unhealthyThreshold)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly =
    zio.aws.apprunner.model.HealthCheckConfiguration.wrap(buildAwsValue())
}
object HealthCheckConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.HealthCheckConfiguration =
      zio.aws.apprunner.model.HealthCheckConfiguration(
        protocol.map(value => value),
        path.map(value => value),
        interval.map(value => value),
        timeout.map(value => value),
        healthyThreshold.map(value => value),
        unhealthyThreshold.map(value => value)
      )
    def protocol: Option[zio.aws.apprunner.model.HealthCheckProtocol]
    def path: Option[HealthCheckPath]
    def interval: Option[HealthCheckInterval]
    def timeout: Option[HealthCheckTimeout]
    def healthyThreshold: Option[HealthCheckHealthyThreshold]
    def unhealthyThreshold: Option[HealthCheckUnhealthyThreshold]
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.apprunner.model.HealthCheckProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPath: ZIO[Any, AwsError, HealthCheckPath] =
      AwsError.unwrapOptionField("path", path)
    def getInterval: ZIO[Any, AwsError, HealthCheckInterval] =
      AwsError.unwrapOptionField("interval", interval)
    def getTimeout: ZIO[Any, AwsError, HealthCheckTimeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getHealthyThreshold: ZIO[Any, AwsError, HealthCheckHealthyThreshold] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getUnhealthyThreshold
        : ZIO[Any, AwsError, HealthCheckUnhealthyThreshold] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ) extends zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly {
    override val protocol: Option[zio.aws.apprunner.model.HealthCheckProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.apprunner.model.HealthCheckProtocol.wrap(value))
    override val path: Option[HealthCheckPath] = scala
      .Option(impl.path())
      .map(value => zio.aws.apprunner.model.primitives.HealthCheckPath(value))
    override val interval: Option[HealthCheckInterval] = scala
      .Option(impl.interval())
      .map(value =>
        zio.aws.apprunner.model.primitives.HealthCheckInterval(value)
      )
    override val timeout: Option[HealthCheckTimeout] = scala
      .Option(impl.timeout())
      .map(value =>
        zio.aws.apprunner.model.primitives.HealthCheckTimeout(value)
      )
    override val healthyThreshold: Option[HealthCheckHealthyThreshold] = scala
      .Option(impl.healthyThreshold())
      .map(value =>
        zio.aws.apprunner.model.primitives.HealthCheckHealthyThreshold(value)
      )
    override val unhealthyThreshold: Option[HealthCheckUnhealthyThreshold] =
      scala
        .Option(impl.unhealthyThreshold())
        .map(value =>
          zio.aws.apprunner.model.primitives
            .HealthCheckUnhealthyThreshold(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration
  ): zio.aws.apprunner.model.HealthCheckConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
