package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait VirtualRouterStatusCode {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode
}
object VirtualRouterStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode
  ): zio.aws.appmesh.model.VirtualRouterStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.VirtualRouterStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.VirtualRouterStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.VirtualRouterStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.VirtualRouterStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualRouterStatusCode.DELETED
  }
}
