package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayLogging(
    accessLog: Optional[zio.aws.appmesh.model.VirtualGatewayAccessLog] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging = {
    import VirtualGatewayLogging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging
      .builder()
      .optionallyWith(accessLog.map(value => value.buildAwsValue()))(
        _.accessLog
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayLogging.wrap(buildAwsValue())
}
object VirtualGatewayLogging {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayLogging =
      zio.aws.appmesh.model
        .VirtualGatewayLogging(accessLog.map(value => value.asEditable))
    def accessLog
        : Optional[zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly]
    def getAccessLog: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly
    ] = AwsError.unwrapOptionField("accessLog", accessLog)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging
  ) extends zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly {
    override val accessLog
        : Optional[zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLog())
        .map(value => zio.aws.appmesh.model.VirtualGatewayAccessLog.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging
  ): zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly = new Wrapper(impl)
}
