package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateVirtualNodeResponse(
    virtualNode: zio.aws.appmesh.model.VirtualNodeData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse = {
    import UpdateVirtualNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse
      .builder()
      .virtualNode(virtualNode.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualNodeResponse.wrap(buildAwsValue())
}
object UpdateVirtualNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualNodeResponse =
      zio.aws.appmesh.model.UpdateVirtualNodeResponse(virtualNode.asEditable)
    def virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly
    def getVirtualNode
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeData.ReadOnly] =
      ZIO.succeed(virtualNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse
  ) extends zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly {
    override val virtualNode: zio.aws.appmesh.model.VirtualNodeData.ReadOnly =
      zio.aws.appmesh.model.VirtualNodeData.wrap(impl.virtualNode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse
  ): zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly = new Wrapper(
    impl
  )
}
