package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait TcpRetryPolicyEvent {
  def unwrap: software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent
}
object TcpRetryPolicyEvent {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent
  ): zio.aws.appmesh.model.TcpRetryPolicyEvent = value match {
    case software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent.CONNECTION_ERROR =>
      val r = `connection-error`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.TcpRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object `connection-error`
      extends zio.aws.appmesh.model.TcpRetryPolicyEvent {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent =
      software.amazon.awssdk.services.appmesh.model.TcpRetryPolicyEvent.CONNECTION_ERROR
  }
}
