package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{JsonValue, JsonKey}
import scala.jdk.CollectionConverters.*
final case class JsonFormatRef(key: JsonKey, value: JsonValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.JsonFormatRef = {
    import JsonFormatRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.JsonFormatRef
      .builder()
      .key(JsonKey.unwrap(key): java.lang.String)
      .value(JsonValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.JsonFormatRef.ReadOnly =
    zio.aws.appmesh.model.JsonFormatRef.wrap(buildAwsValue())
}
object JsonFormatRef {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.JsonFormatRef
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.JsonFormatRef =
      zio.aws.appmesh.model.JsonFormatRef(key, value)
    def key: JsonKey
    def value: JsonValue
    def getKey: ZIO[Any, Nothing, JsonKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, JsonValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.JsonFormatRef
  ) extends zio.aws.appmesh.model.JsonFormatRef.ReadOnly {
    override val key: JsonKey =
      zio.aws.appmesh.model.primitives.JsonKey(impl.key())
    override val value: JsonValue =
      zio.aws.appmesh.model.primitives.JsonValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.JsonFormatRef
  ): zio.aws.appmesh.model.JsonFormatRef.ReadOnly = new Wrapper(impl)
}
