package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BackendDefaults(
    clientPolicy: Optional[zio.aws.appmesh.model.ClientPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.BackendDefaults = {
    import BackendDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.BackendDefaults
      .builder()
      .optionallyWith(clientPolicy.map(value => value.buildAwsValue()))(
        _.clientPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.BackendDefaults.ReadOnly =
    zio.aws.appmesh.model.BackendDefaults.wrap(buildAwsValue())
}
object BackendDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.BackendDefaults =
      zio.aws.appmesh.model
        .BackendDefaults(clientPolicy.map(value => value.asEditable))
    def clientPolicy: Optional[zio.aws.appmesh.model.ClientPolicy.ReadOnly]
    def getClientPolicy
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ClientPolicy.ReadOnly] =
      AwsError.unwrapOptionField("clientPolicy", clientPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ) extends zio.aws.appmesh.model.BackendDefaults.ReadOnly {
    override val clientPolicy
        : Optional[zio.aws.appmesh.model.ClientPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientPolicy())
        .map(value => zio.aws.appmesh.model.ClientPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ): zio.aws.appmesh.model.BackendDefaults.ReadOnly = new Wrapper(impl)
}
