package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListener(
    connectionPool: Optional[
      zio.aws.appmesh.model.VirtualGatewayConnectionPool
    ] = Optional.Absent,
    healthCheck: Optional[
      zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy
    ] = Optional.Absent,
    portMapping: zio.aws.appmesh.model.VirtualGatewayPortMapping,
    tls: Optional[zio.aws.appmesh.model.VirtualGatewayListenerTls] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener = {
    import VirtualGatewayListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener
      .builder()
      .optionallyWith(connectionPool.map(value => value.buildAwsValue()))(
        _.connectionPool
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .portMapping(portMapping.buildAwsValue())
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListener.wrap(buildAwsValue())
}
object VirtualGatewayListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayListener =
      zio.aws.appmesh.model.VirtualGatewayListener(
        connectionPool.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        portMapping.asEditable,
        tls.map(value => value.asEditable)
      )
    def connectionPool
        : Optional[zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly]
    def healthCheck: Optional[
      zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly
    ]
    def portMapping: zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly
    def tls: Optional[zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly]
    def getConnectionPool: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPool", connectionPool)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getPortMapping: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly
    ] = ZIO.succeed(portMapping)
    def getTls: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly
    ] = AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener
  ) extends zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly {
    override val connectionPool: Optional[
      zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionPool())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayConnectionPool.wrap(value)
      )
    override val healthCheck: Optional[
      zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheck())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayHealthCheckPolicy.wrap(value)
      )
    override val portMapping
        : zio.aws.appmesh.model.VirtualGatewayPortMapping.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayPortMapping.wrap(impl.portMapping())
    override val tls
        : Optional[zio.aws.appmesh.model.VirtualGatewayListenerTls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tls())
        .map(value =>
          zio.aws.appmesh.model.VirtualGatewayListenerTls.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener
  ): zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly = new Wrapper(impl)
}
