package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class TagRef(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.appmesh.model.TagRef = {
    import TagRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TagRef
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TagRef.ReadOnly =
    zio.aws.appmesh.model.TagRef.wrap(buildAwsValue())
}
object TagRef {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.TagRef] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TagRef =
      zio.aws.appmesh.model.TagRef(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TagRef
  ) extends zio.aws.appmesh.model.TagRef.ReadOnly {
    override val key: TagKey =
      zio.aws.appmesh.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.appmesh.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TagRef
  ): zio.aws.appmesh.model.TagRef.ReadOnly = new Wrapper(impl)
}
