package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait HttpMethod {
  def unwrap: software.amazon.awssdk.services.appmesh.model.HttpMethod
}
object HttpMethod {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.HttpMethod
  ): zio.aws.appmesh.model.HttpMethod = value match {
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.GET =>
      val r = GET
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.HEAD =>
      val r = HEAD
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.POST =>
      val r = POST
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.CONNECT =>
      val r = CONNECT
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.OPTIONS =>
      val r = OPTIONS
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.TRACE =>
      val r = TRACE
      r
    case software.amazon.awssdk.services.appmesh.model.HttpMethod.PATCH =>
      val r = PATCH
      r
  }
  case object unknownToSdkVersion extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object GET extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.GET
  }
  case object HEAD extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.HEAD
  }
  case object POST extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.POST
  }
  case object PUT extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.PUT
  }
  case object DELETE extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.DELETE
  }
  case object CONNECT extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.CONNECT
  }
  case object OPTIONS extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.OPTIONS
  }
  case object TRACE extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.TRACE
  }
  case object PATCH extends zio.aws.appmesh.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.HttpMethod =
      software.amazon.awssdk.services.appmesh.model.HttpMethod.PATCH
  }
}
