package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.{MaxRetries, HttpRetryPolicyEvent}
import scala.jdk.CollectionConverters.*
final case class GrpcRetryPolicy(
    grpcRetryEvents: Optional[
      Iterable[zio.aws.appmesh.model.GrpcRetryPolicyEvent]
    ] = Optional.Absent,
    httpRetryEvents: Optional[Iterable[HttpRetryPolicyEvent]] = Optional.Absent,
    maxRetries: MaxRetries,
    perRetryTimeout: zio.aws.appmesh.model.Duration,
    tcpRetryEvents: Optional[
      Iterable[zio.aws.appmesh.model.TcpRetryPolicyEvent]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy = {
    import GrpcRetryPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy
      .builder()
      .optionallyWith(
        grpcRetryEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.grpcRetryEventsWithStrings)
      .optionallyWith(
        httpRetryEvents.map(value =>
          value.map { item =>
            HttpRetryPolicyEvent.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.httpRetryEvents)
      .maxRetries(MaxRetries.unwrap(maxRetries): java.lang.Long)
      .perRetryTimeout(perRetryTimeout.buildAwsValue())
      .optionallyWith(
        tcpRetryEvents.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.tcpRetryEventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly =
    zio.aws.appmesh.model.GrpcRetryPolicy.wrap(buildAwsValue())
}
object GrpcRetryPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcRetryPolicy =
      zio.aws.appmesh.model.GrpcRetryPolicy(
        grpcRetryEvents.map(value => value),
        httpRetryEvents.map(value => value),
        maxRetries,
        perRetryTimeout.asEditable,
        tcpRetryEvents.map(value => value)
      )
    def grpcRetryEvents
        : Optional[List[zio.aws.appmesh.model.GrpcRetryPolicyEvent]]
    def httpRetryEvents: Optional[List[HttpRetryPolicyEvent]]
    def maxRetries: MaxRetries
    def perRetryTimeout: zio.aws.appmesh.model.Duration.ReadOnly
    def tcpRetryEvents
        : Optional[List[zio.aws.appmesh.model.TcpRetryPolicyEvent]]
    def getGrpcRetryEvents
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.GrpcRetryPolicyEvent]] =
      AwsError.unwrapOptionField("grpcRetryEvents", grpcRetryEvents)
    def getHttpRetryEvents: ZIO[Any, AwsError, List[HttpRetryPolicyEvent]] =
      AwsError.unwrapOptionField("httpRetryEvents", httpRetryEvents)
    def getMaxRetries: ZIO[Any, Nothing, MaxRetries] = ZIO.succeed(maxRetries)
    def getPerRetryTimeout
        : ZIO[Any, Nothing, zio.aws.appmesh.model.Duration.ReadOnly] =
      ZIO.succeed(perRetryTimeout)
    def getTcpRetryEvents
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TcpRetryPolicyEvent]] =
      AwsError.unwrapOptionField("tcpRetryEvents", tcpRetryEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy
  ) extends zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly {
    override val grpcRetryEvents
        : Optional[List[zio.aws.appmesh.model.GrpcRetryPolicyEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grpcRetryEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.GrpcRetryPolicyEvent.wrap(item)
          }.toList
        )
    override val httpRetryEvents: Optional[List[HttpRetryPolicyEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpRetryEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.primitives.HttpRetryPolicyEvent(item)
          }.toList
        )
    override val maxRetries: MaxRetries =
      zio.aws.appmesh.model.primitives.MaxRetries(impl.maxRetries())
    override val perRetryTimeout: zio.aws.appmesh.model.Duration.ReadOnly =
      zio.aws.appmesh.model.Duration.wrap(impl.perRetryTimeout())
    override val tcpRetryEvents
        : Optional[List[zio.aws.appmesh.model.TcpRetryPolicyEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tcpRetryEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.TcpRetryPolicyEvent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRetryPolicy
  ): zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly = new Wrapper(impl)
}
