package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.HeaderMatch
import scala.jdk.CollectionConverters.*
final case class GrpcMetadataMatchMethod(
    exact: Optional[HeaderMatch] = Optional.Absent,
    prefix: Optional[HeaderMatch] = Optional.Absent,
    range: Optional[zio.aws.appmesh.model.MatchRange] = Optional.Absent,
    regex: Optional[HeaderMatch] = Optional.Absent,
    suffix: Optional[HeaderMatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcMetadataMatchMethod = {
    import GrpcMetadataMatchMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcMetadataMatchMethod
      .builder()
      .optionallyWith(
        exact.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.exact)
      .optionallyWith(
        prefix.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(range.map(value => value.buildAwsValue()))(_.range)
      .optionallyWith(
        regex.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        suffix.map(value => HeaderMatch.unwrap(value): java.lang.String)
      )(_.suffix)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcMetadataMatchMethod.ReadOnly =
    zio.aws.appmesh.model.GrpcMetadataMatchMethod.wrap(buildAwsValue())
}
object GrpcMetadataMatchMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcMetadataMatchMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcMetadataMatchMethod =
      zio.aws.appmesh.model.GrpcMetadataMatchMethod(
        exact.map(value => value),
        prefix.map(value => value),
        range.map(value => value.asEditable),
        regex.map(value => value),
        suffix.map(value => value)
      )
    def exact: Optional[HeaderMatch]
    def prefix: Optional[HeaderMatch]
    def range: Optional[zio.aws.appmesh.model.MatchRange.ReadOnly]
    def regex: Optional[HeaderMatch]
    def suffix: Optional[HeaderMatch]
    def getExact: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("exact", exact)
    def getPrefix: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getRange
        : ZIO[Any, AwsError, zio.aws.appmesh.model.MatchRange.ReadOnly] =
      AwsError.unwrapOptionField("range", range)
    def getRegex: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("regex", regex)
    def getSuffix: ZIO[Any, AwsError, HeaderMatch] =
      AwsError.unwrapOptionField("suffix", suffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcMetadataMatchMethod
  ) extends zio.aws.appmesh.model.GrpcMetadataMatchMethod.ReadOnly {
    override val exact: Optional[HeaderMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val prefix: Optional[HeaderMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val range: Optional[zio.aws.appmesh.model.MatchRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.range())
        .map(value => zio.aws.appmesh.model.MatchRange.wrap(value))
    override val regex: Optional[HeaderMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.regex())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
    override val suffix: Optional[HeaderMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.suffix())
      .map(value => zio.aws.appmesh.model.primitives.HeaderMatch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcMetadataMatchMethod
  ): zio.aws.appmesh.model.GrpcMetadataMatchMethod.ReadOnly = new Wrapper(impl)
}
