package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateVirtualRouterResponse(
    virtualRouter: zio.aws.appmesh.model.VirtualRouterData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse = {
    import CreateVirtualRouterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse
      .builder()
      .virtualRouter(virtualRouter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly =
    zio.aws.appmesh.model.CreateVirtualRouterResponse.wrap(buildAwsValue())
}
object CreateVirtualRouterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateVirtualRouterResponse =
      zio.aws.appmesh.model
        .CreateVirtualRouterResponse(virtualRouter.asEditable)
    def virtualRouter: zio.aws.appmesh.model.VirtualRouterData.ReadOnly
    def getVirtualRouter
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterData.ReadOnly] =
      ZIO.succeed(virtualRouter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse
  ) extends zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly {
    override val virtualRouter
        : zio.aws.appmesh.model.VirtualRouterData.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterData.wrap(impl.virtualRouter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse
  ): zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly = new Wrapper(
    impl
  )
}
