package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.ResourceName
import scala.jdk.CollectionConverters.*
final case class CreateMeshRequest(
    clientToken: Optional[String] = Optional.Absent,
    meshName: ResourceName,
    spec: Optional[zio.aws.appmesh.model.MeshSpec] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.appmesh.model.TagRef]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateMeshRequest = {
    import CreateMeshRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateMeshRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(spec.map(value => value.buildAwsValue()))(_.spec)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateMeshRequest.ReadOnly =
    zio.aws.appmesh.model.CreateMeshRequest.wrap(buildAwsValue())
}
object CreateMeshRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateMeshRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateMeshRequest =
      zio.aws.appmesh.model.CreateMeshRequest(
        clientToken.map(value => value),
        meshName,
        spec.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[String]
    def meshName: ResourceName
    def spec: Optional[zio.aws.appmesh.model.MeshSpec.ReadOnly]
    def tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getSpec: ZIO[Any, AwsError, zio.aws.appmesh.model.MeshSpec.ReadOnly] =
      AwsError.unwrapOptionField("spec", spec)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateMeshRequest
  ) extends zio.aws.appmesh.model.CreateMeshRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val spec: Optional[zio.aws.appmesh.model.MeshSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spec())
        .map(value => zio.aws.appmesh.model.MeshSpec.wrap(value))
    override val tags: Optional[List[zio.aws.appmesh.model.TagRef.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.TagRef.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateMeshRequest
  ): zio.aws.appmesh.model.CreateMeshRequest.ReadOnly = new Wrapper(impl)
}
