package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{PercentInt, ResourceName, ListenerPort}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WeightedTarget(
    port: Optional[ListenerPort] = Optional.Absent,
    virtualNode: ResourceName,
    weight: PercentInt
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.WeightedTarget = {
    import WeightedTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.WeightedTarget
      .builder()
      .optionallyWith(port.map(value => ListenerPort.unwrap(value): Integer))(
        _.port
      )
      .virtualNode(ResourceName.unwrap(virtualNode): java.lang.String)
      .weight(PercentInt.unwrap(weight): Integer)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.WeightedTarget.ReadOnly =
    zio.aws.appmesh.model.WeightedTarget.wrap(buildAwsValue())
}
object WeightedTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.WeightedTarget = zio.aws.appmesh.model
      .WeightedTarget(port.map(value => value), virtualNode, weight)
    def port: Optional[ListenerPort]
    def virtualNode: ResourceName
    def weight: PercentInt
    def getPort: ZIO[Any, AwsError, ListenerPort] =
      AwsError.unwrapOptionField("port", port)
    def getVirtualNode: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNode)
    def getWeight: ZIO[Any, Nothing, PercentInt] = ZIO.succeed(weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ) extends zio.aws.appmesh.model.WeightedTarget.ReadOnly {
    override val port: Optional[ListenerPort] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.ListenerPort(value))
    override val virtualNode: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNode())
    override val weight: PercentInt =
      zio.aws.appmesh.model.primitives.PercentInt(impl.weight())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ): zio.aws.appmesh.model.WeightedTarget.ReadOnly = new Wrapper(impl)
}
