package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateVirtualRouterResponse(
    virtualRouter: zio.aws.appmesh.model.VirtualRouterData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse = {
    import UpdateVirtualRouterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse
      .builder()
      .virtualRouter(virtualRouter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualRouterResponse.wrap(buildAwsValue())
}
object UpdateVirtualRouterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualRouterResponse =
      zio.aws.appmesh.model
        .UpdateVirtualRouterResponse(virtualRouter.asEditable)
    def virtualRouter: zio.aws.appmesh.model.VirtualRouterData.ReadOnly
    def getVirtualRouter
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualRouterData.ReadOnly] =
      ZIO.succeed(virtualRouter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse
  ) extends zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly {
    override val virtualRouter
        : zio.aws.appmesh.model.VirtualRouterData.ReadOnly =
      zio.aws.appmesh.model.VirtualRouterData.wrap(impl.virtualRouter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse
  ): zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly = new Wrapper(
    impl
  )
}
