package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.PortNumber
import scala.jdk.CollectionConverters.*
final case class PortMapping(
    port: PortNumber,
    protocol: zio.aws.appmesh.model.PortProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.PortMapping
      .builder()
      .port(PortNumber.unwrap(port): Integer)
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.PortMapping.ReadOnly =
    zio.aws.appmesh.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.PortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.PortMapping =
      zio.aws.appmesh.model.PortMapping(port, protocol)
    def port: PortNumber
    def protocol: zio.aws.appmesh.model.PortProtocol
    def getPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(port)
    def getProtocol: ZIO[Any, Nothing, zio.aws.appmesh.model.PortProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.PortMapping
  ) extends zio.aws.appmesh.model.PortMapping.ReadOnly {
    override val port: PortNumber =
      zio.aws.appmesh.model.primitives.PortNumber(impl.port())
    override val protocol: zio.aws.appmesh.model.PortProtocol =
      zio.aws.appmesh.model.PortProtocol.wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.PortMapping
  ): zio.aws.appmesh.model.PortMapping.ReadOnly = new Wrapper(impl)
}
