package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.SdsSecretName
import scala.jdk.CollectionConverters.*
final case class ListenerTlsSdsCertificate(secretName: SdsSecretName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate = {
    import ListenerTlsSdsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate
      .builder()
      .secretName(SdsSecretName.unwrap(secretName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsSdsCertificate.wrap(buildAwsValue())
}
object ListenerTlsSdsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsSdsCertificate =
      zio.aws.appmesh.model.ListenerTlsSdsCertificate(secretName)
    def secretName: SdsSecretName
    def getSecretName: ZIO[Any, Nothing, SdsSecretName] =
      ZIO.succeed(secretName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate
  ) extends zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly {
    override val secretName: SdsSecretName =
      zio.aws.appmesh.model.primitives.SdsSecretName(impl.secretName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate
  ): zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly = new Wrapper(
    impl
  )
}
