package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{Arn, TagsLimit}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    limit: Optional[TagsLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(limit.map(value => TagsLimit.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.appmesh.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListTagsForResourceRequest =
      zio.aws.appmesh.model.ListTagsForResourceRequest(
        limit.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def limit: Optional[TagsLimit]
    def nextToken: Optional[String]
    def resourceArn: Arn
    def getLimit: ZIO[Any, AwsError, TagsLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest
  ) extends zio.aws.appmesh.model.ListTagsForResourceRequest.ReadOnly {
    override val limit: Optional[TagsLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.appmesh.model.primitives.TagsLimit(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resourceArn: Arn =
      zio.aws.appmesh.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest
  ): zio.aws.appmesh.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
