package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrpcTimeout(
    idle: Optional[zio.aws.appmesh.model.Duration] = Optional.Absent,
    perRequest: Optional[zio.aws.appmesh.model.Duration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcTimeout = {
    import GrpcTimeout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcTimeout
      .builder()
      .optionallyWith(idle.map(value => value.buildAwsValue()))(_.idle)
      .optionallyWith(perRequest.map(value => value.buildAwsValue()))(
        _.perRequest
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcTimeout.ReadOnly =
    zio.aws.appmesh.model.GrpcTimeout.wrap(buildAwsValue())
}
object GrpcTimeout {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcTimeout
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcTimeout =
      zio.aws.appmesh.model.GrpcTimeout(
        idle.map(value => value.asEditable),
        perRequest.map(value => value.asEditable)
      )
    def idle: Optional[zio.aws.appmesh.model.Duration.ReadOnly]
    def perRequest: Optional[zio.aws.appmesh.model.Duration.ReadOnly]
    def getIdle: ZIO[Any, AwsError, zio.aws.appmesh.model.Duration.ReadOnly] =
      AwsError.unwrapOptionField("idle", idle)
    def getPerRequest
        : ZIO[Any, AwsError, zio.aws.appmesh.model.Duration.ReadOnly] =
      AwsError.unwrapOptionField("perRequest", perRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcTimeout
  ) extends zio.aws.appmesh.model.GrpcTimeout.ReadOnly {
    override val idle: Optional[zio.aws.appmesh.model.Duration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idle())
        .map(value => zio.aws.appmesh.model.Duration.wrap(value))
    override val perRequest: Optional[zio.aws.appmesh.model.Duration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.perRequest())
        .map(value => zio.aws.appmesh.model.Duration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcTimeout
  ): zio.aws.appmesh.model.GrpcTimeout.ReadOnly = new Wrapper(impl)
}
