package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrpcRoute(
    action: zio.aws.appmesh.model.GrpcRouteAction,
    `match`: zio.aws.appmesh.model.GrpcRouteMatch,
    retryPolicy: Optional[zio.aws.appmesh.model.GrpcRetryPolicy] =
      Optional.Absent,
    timeout: Optional[zio.aws.appmesh.model.GrpcTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcRoute = {
    import GrpcRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcRoute
      .builder()
      .action(action.buildAwsValue())
      .`match`(`match`.buildAwsValue())
      .optionallyWith(retryPolicy.map(value => value.buildAwsValue()))(
        _.retryPolicy
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcRoute.ReadOnly =
    zio.aws.appmesh.model.GrpcRoute.wrap(buildAwsValue())
}
object GrpcRoute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.GrpcRoute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcRoute =
      zio.aws.appmesh.model.GrpcRoute(
        action.asEditable,
        `match`.asEditable,
        retryPolicy.map(value => value.asEditable),
        timeout.map(value => value.asEditable)
      )
    def action: zio.aws.appmesh.model.GrpcRouteAction.ReadOnly
    def `match`: zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly
    def retryPolicy: Optional[zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly]
    def timeout: Optional[zio.aws.appmesh.model.GrpcTimeout.ReadOnly]
    def getAction
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GrpcRouteAction.ReadOnly] =
      ZIO.succeed(action)
    def getMatch
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly] =
      ZIO.succeed(`match`)
    def getRetryPolicy
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly] =
      AwsError.unwrapOptionField("retryPolicy", retryPolicy)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRoute
  ) extends zio.aws.appmesh.model.GrpcRoute.ReadOnly {
    override val action: zio.aws.appmesh.model.GrpcRouteAction.ReadOnly =
      zio.aws.appmesh.model.GrpcRouteAction.wrap(impl.action())
    override val `match`: zio.aws.appmesh.model.GrpcRouteMatch.ReadOnly =
      zio.aws.appmesh.model.GrpcRouteMatch.wrap(impl.`match`())
    override val retryPolicy
        : Optional[zio.aws.appmesh.model.GrpcRetryPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryPolicy())
        .map(value => zio.aws.appmesh.model.GrpcRetryPolicy.wrap(value))
    override val timeout: Optional[zio.aws.appmesh.model.GrpcTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeout())
        .map(value => zio.aws.appmesh.model.GrpcTimeout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcRoute
  ): zio.aws.appmesh.model.GrpcRoute.ReadOnly = new Wrapper(impl)
}
