package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GatewayRouteStatus(
    status: zio.aws.appmesh.model.GatewayRouteStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus = {
    import GatewayRouteStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteStatus.wrap(buildAwsValue())
}
object GatewayRouteStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteStatus =
      zio.aws.appmesh.model.GatewayRouteStatus(status)
    def status: zio.aws.appmesh.model.GatewayRouteStatusCode
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus
  ) extends zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.GatewayRouteStatusCode =
      zio.aws.appmesh.model.GatewayRouteStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteStatus
  ): zio.aws.appmesh.model.GatewayRouteStatus.ReadOnly = new Wrapper(impl)
}
