package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRouteResponse(route: zio.aws.appmesh.model.RouteData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse = {
    import DeleteRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse
      .builder()
      .route(route.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly =
    zio.aws.appmesh.model.DeleteRouteResponse.wrap(buildAwsValue())
}
object DeleteRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteRouteResponse =
      zio.aws.appmesh.model.DeleteRouteResponse(route.asEditable)
    def route: zio.aws.appmesh.model.RouteData.ReadOnly
    def getRoute: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteData.ReadOnly] =
      ZIO.succeed(route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse
  ) extends zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly {
    override val route: zio.aws.appmesh.model.RouteData.ReadOnly =
      zio.aws.appmesh.model.RouteData.wrap(impl.route())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse
  ): zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly = new Wrapper(impl)
}
