package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTlsCertificate(
    acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
    ] = Optional.Absent,
    file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate
    ] = Optional.Absent,
    sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsCertificate = {
    import VirtualGatewayListenerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsCertificate
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate =
      zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly
    ]
    def file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ]
    def sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsCertificate
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly {
    override val acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acm())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsAcmCertificate
          .wrap(value)
      )
    override val file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate
          .wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsCertificate
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsCertificate.ReadOnly =
    new Wrapper(impl)
}
