package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TlsValidationContextTrust(
    acm: Optional[zio.aws.appmesh.model.TlsValidationContextAcmTrust] =
      Optional.Absent,
    file: Optional[zio.aws.appmesh.model.TlsValidationContextFileTrust] =
      Optional.Absent,
    sds: Optional[zio.aws.appmesh.model.TlsValidationContextSdsTrust] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust = {
    import TlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.TlsValidationContextTrust.wrap(buildAwsValue())
}
object TlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TlsValidationContextTrust =
      zio.aws.appmesh.model.TlsValidationContextTrust(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm
        : Optional[zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly]
    def file
        : Optional[zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly]
    def sds
        : Optional[zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ) extends zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly {
    override val acm: Optional[
      zio.aws.appmesh.model.TlsValidationContextAcmTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acm())
      .map(value =>
        zio.aws.appmesh.model.TlsValidationContextAcmTrust.wrap(value)
      )
    override val file: Optional[
      zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.TlsValidationContextFileTrust.wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.TlsValidationContextSdsTrust.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TlsValidationContextTrust
  ): zio.aws.appmesh.model.TlsValidationContextTrust.ReadOnly = new Wrapper(
    impl
  )
}
