package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{AccountId, Timestamp, Arn}
import scala.jdk.CollectionConverters.*
final case class ResourceMetadata(
    arn: Arn,
    createdAt: Timestamp,
    lastUpdatedAt: Timestamp,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    uid: String,
    version: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ResourceMetadata = {
    import ResourceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ResourceMetadata
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .uid(uid: java.lang.String)
      .version(version: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ResourceMetadata.ReadOnly =
    zio.aws.appmesh.model.ResourceMetadata.wrap(buildAwsValue())
}
object ResourceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ResourceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ResourceMetadata =
      zio.aws.appmesh.model.ResourceMetadata(
        arn,
        createdAt,
        lastUpdatedAt,
        meshOwner,
        resourceOwner,
        uid,
        version
      )
    def arn: Arn
    def createdAt: Timestamp
    def lastUpdatedAt: Timestamp
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def uid: String
    def version: Long
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getUid: ZIO[Any, Nothing, String] = ZIO.succeed(uid)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ResourceMetadata
  ) extends zio.aws.appmesh.model.ResourceMetadata.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val uid: String = impl.uid(): String
    override val version: Long = impl.version(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ResourceMetadata
  ): zio.aws.appmesh.model.ResourceMetadata.ReadOnly = new Wrapper(impl)
}
