package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait DefaultGatewayRouteRewrite {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite
}
object DefaultGatewayRouteRewrite {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite
  ): zio.aws.appmesh.model.DefaultGatewayRouteRewrite = value match {
    case software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.DefaultGatewayRouteRewrite {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite =
      software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.appmesh.model.DefaultGatewayRouteRewrite {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite =
      software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.ENABLED
  }
  case object DISABLED
      extends zio.aws.appmesh.model.DefaultGatewayRouteRewrite {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite =
      software.amazon.awssdk.services.appmesh.model.DefaultGatewayRouteRewrite.DISABLED
  }
}
