package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualRouterSpec(
    listeners: Optional[Iterable[zio.aws.appmesh.model.VirtualRouterListener]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec = {
    import VirtualRouterSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly =
    zio.aws.appmesh.model.VirtualRouterSpec.wrap(buildAwsValue())
}
object VirtualRouterSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualRouterSpec =
      zio.aws.appmesh.model.VirtualRouterSpec(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listeners
        : Optional[List[zio.aws.appmesh.model.VirtualRouterListener.ReadOnly]]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.appmesh.model.VirtualRouterListener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec
  ) extends zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly {
    override val listeners
        : Optional[List[zio.aws.appmesh.model.VirtualRouterListener.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listeners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appmesh.model.VirtualRouterListener.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterSpec
  ): zio.aws.appmesh.model.VirtualRouterSpec.ReadOnly = new Wrapper(impl)
}
