package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VirtualRouterListener(
    portMapping: zio.aws.appmesh.model.PortMapping
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualRouterListener = {
    import VirtualRouterListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualRouterListener
      .builder()
      .portMapping(portMapping.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualRouterListener.ReadOnly =
    zio.aws.appmesh.model.VirtualRouterListener.wrap(buildAwsValue())
}
object VirtualRouterListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualRouterListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualRouterListener =
      zio.aws.appmesh.model.VirtualRouterListener(portMapping.asEditable)
    def portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly
    def getPortMapping
        : ZIO[Any, Nothing, zio.aws.appmesh.model.PortMapping.ReadOnly] =
      ZIO.succeed(portMapping)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterListener
  ) extends zio.aws.appmesh.model.VirtualRouterListener.ReadOnly {
    override val portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly =
      zio.aws.appmesh.model.PortMapping.wrap(impl.portMapping())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualRouterListener
  ): zio.aws.appmesh.model.VirtualRouterListener.ReadOnly = new Wrapper(impl)
}
