package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TcpRouteAction(
    weightedTargets: Iterable[zio.aws.appmesh.model.WeightedTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TcpRouteAction = {
    import TcpRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TcpRouteAction
      .builder()
      .weightedTargets(weightedTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TcpRouteAction.ReadOnly =
    zio.aws.appmesh.model.TcpRouteAction.wrap(buildAwsValue())
}
object TcpRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TcpRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TcpRouteAction =
      zio.aws.appmesh.model.TcpRouteAction(weightedTargets.map { item =>
        item.asEditable
      })
    def weightedTargets: List[zio.aws.appmesh.model.WeightedTarget.ReadOnly]
    def getWeightedTargets: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.WeightedTarget.ReadOnly
    ]] = ZIO.succeed(weightedTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRouteAction
  ) extends zio.aws.appmesh.model.TcpRouteAction.ReadOnly {
    override val weightedTargets
        : List[zio.aws.appmesh.model.WeightedTarget.ReadOnly] = impl
      .weightedTargets()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.WeightedTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRouteAction
  ): zio.aws.appmesh.model.TcpRouteAction.ReadOnly = new Wrapper(impl)
}
