package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{
  HealthCheckTimeoutMillis,
  PortNumber,
  HealthCheckIntervalMillis,
  HealthCheckThreshold
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HealthCheckPolicy(
    healthyThreshold: HealthCheckThreshold,
    intervalMillis: HealthCheckIntervalMillis,
    path: Optional[String] = Optional.Absent,
    port: Optional[PortNumber] = Optional.Absent,
    protocol: zio.aws.appmesh.model.PortProtocol,
    timeoutMillis: HealthCheckTimeoutMillis,
    unhealthyThreshold: HealthCheckThreshold
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy = {
    import HealthCheckPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy
      .builder()
      .healthyThreshold(HealthCheckThreshold.unwrap(healthyThreshold): Integer)
      .intervalMillis(
        HealthCheckIntervalMillis.unwrap(intervalMillis): java.lang.Long
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .protocol(protocol.unwrap)
      .timeoutMillis(
        HealthCheckTimeoutMillis.unwrap(timeoutMillis): java.lang.Long
      )
      .unhealthyThreshold(
        HealthCheckThreshold.unwrap(unhealthyThreshold): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly =
    zio.aws.appmesh.model.HealthCheckPolicy.wrap(buildAwsValue())
}
object HealthCheckPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HealthCheckPolicy =
      zio.aws.appmesh.model.HealthCheckPolicy(
        healthyThreshold,
        intervalMillis,
        path.map(value => value),
        port.map(value => value),
        protocol,
        timeoutMillis,
        unhealthyThreshold
      )
    def healthyThreshold: HealthCheckThreshold
    def intervalMillis: HealthCheckIntervalMillis
    def path: Optional[String]
    def port: Optional[PortNumber]
    def protocol: zio.aws.appmesh.model.PortProtocol
    def timeoutMillis: HealthCheckTimeoutMillis
    def unhealthyThreshold: HealthCheckThreshold
    def getHealthyThreshold: ZIO[Any, Nothing, HealthCheckThreshold] =
      ZIO.succeed(healthyThreshold)
    def getIntervalMillis: ZIO[Any, Nothing, HealthCheckIntervalMillis] =
      ZIO.succeed(intervalMillis)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getProtocol: ZIO[Any, Nothing, zio.aws.appmesh.model.PortProtocol] =
      ZIO.succeed(protocol)
    def getTimeoutMillis: ZIO[Any, Nothing, HealthCheckTimeoutMillis] =
      ZIO.succeed(timeoutMillis)
    def getUnhealthyThreshold: ZIO[Any, Nothing, HealthCheckThreshold] =
      ZIO.succeed(unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy
  ) extends zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly {
    override val healthyThreshold: HealthCheckThreshold =
      zio.aws.appmesh.model.primitives
        .HealthCheckThreshold(impl.healthyThreshold())
    override val intervalMillis: HealthCheckIntervalMillis =
      zio.aws.appmesh.model.primitives
        .HealthCheckIntervalMillis(impl.intervalMillis())
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val port: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.appmesh.model.primitives.PortNumber(value))
    override val protocol: zio.aws.appmesh.model.PortProtocol =
      zio.aws.appmesh.model.PortProtocol.wrap(impl.protocol())
    override val timeoutMillis: HealthCheckTimeoutMillis =
      zio.aws.appmesh.model.primitives
        .HealthCheckTimeoutMillis(impl.timeoutMillis())
    override val unhealthyThreshold: HealthCheckThreshold =
      zio.aws.appmesh.model.primitives
        .HealthCheckThreshold(impl.unhealthyThreshold())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HealthCheckPolicy
  ): zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly = new Wrapper(impl)
}
