package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRouteResponse(route: zio.aws.appmesh.model.RouteData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse = {
    import UpdateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse
      .builder()
      .route(route.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly =
    zio.aws.appmesh.model.UpdateRouteResponse.wrap(buildAwsValue())
}
object UpdateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateRouteResponse =
      zio.aws.appmesh.model.UpdateRouteResponse(route.asEditable)
    def route: zio.aws.appmesh.model.RouteData.ReadOnly
    def getRoute: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteData.ReadOnly] =
      ZIO.succeed(route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse
  ) extends zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly {
    override val route: zio.aws.appmesh.model.RouteData.ReadOnly =
      zio.aws.appmesh.model.RouteData.wrap(impl.route())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse
  ): zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly = new Wrapper(impl)
}
