package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TcpRoute(
    action: zio.aws.appmesh.model.TcpRouteAction,
    timeout: Optional[zio.aws.appmesh.model.TcpTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TcpRoute = {
    import TcpRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TcpRoute
      .builder()
      .action(action.buildAwsValue())
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TcpRoute.ReadOnly =
    zio.aws.appmesh.model.TcpRoute.wrap(buildAwsValue())
}
object TcpRoute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.TcpRoute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TcpRoute = zio.aws.appmesh.model
      .TcpRoute(action.asEditable, timeout.map(value => value.asEditable))
    def action: zio.aws.appmesh.model.TcpRouteAction.ReadOnly
    def timeout: Optional[zio.aws.appmesh.model.TcpTimeout.ReadOnly]
    def getAction
        : ZIO[Any, Nothing, zio.aws.appmesh.model.TcpRouteAction.ReadOnly] =
      ZIO.succeed(action)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.appmesh.model.TcpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRoute
  ) extends zio.aws.appmesh.model.TcpRoute.ReadOnly {
    override val action: zio.aws.appmesh.model.TcpRouteAction.ReadOnly =
      zio.aws.appmesh.model.TcpRouteAction.wrap(impl.action())
    override val timeout: Optional[zio.aws.appmesh.model.TcpTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeout())
        .map(value => zio.aws.appmesh.model.TcpTimeout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TcpRoute
  ): zio.aws.appmesh.model.TcpRoute.ReadOnly = new Wrapper(impl)
}
