package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListenerTlsValidationContextTrust(
    file: Optional[zio.aws.appmesh.model.TlsValidationContextFileTrust] =
      Optional.Absent,
    sds: Optional[zio.aws.appmesh.model.TlsValidationContextSdsTrust] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContextTrust = {
    import ListenerTlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContextTrust
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsValidationContextTrust
      .wrap(buildAwsValue())
}
object ListenerTlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsValidationContextTrust =
      zio.aws.appmesh.model.ListenerTlsValidationContextTrust(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file
        : Optional[zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly]
    def sds
        : Optional[zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContextTrust
  ) extends zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly {
    override val file: Optional[
      zio.aws.appmesh.model.TlsValidationContextFileTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.TlsValidationContextFileTrust.wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.TlsValidationContextSdsTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.TlsValidationContextSdsTrust.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContextTrust
  ): zio.aws.appmesh.model.ListenerTlsValidationContextTrust.ReadOnly =
    new Wrapper(impl)
}
