package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListenerTlsCertificate(
    acm: Optional[zio.aws.appmesh.model.ListenerTlsAcmCertificate] =
      Optional.Absent,
    file: Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate] =
      Optional.Absent,
    sds: Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate = {
    import ListenerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsCertificate.wrap(buildAwsValue())
}
object ListenerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsCertificate =
      zio.aws.appmesh.model.ListenerTlsCertificate(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Optional[zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly]
    def file
        : Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly]
    def sds: Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ) extends zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly {
    override val acm
        : Optional[zio.aws.appmesh.model.ListenerTlsAcmCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acm())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsAcmCertificate.wrap(value)
        )
    override val file
        : Optional[zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsFileCertificate.wrap(value)
        )
    override val sds
        : Optional[zio.aws.appmesh.model.ListenerTlsSdsCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sds())
        .map(value =>
          zio.aws.appmesh.model.ListenerTlsSdsCertificate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate
  ): zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly = new Wrapper(impl)
}
