package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListVirtualRoutersLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVirtualRoutersRequest(
    limit: Optional[ListVirtualRoutersLimit] = Optional.Absent,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest = {
    import ListVirtualRoutersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListVirtualRoutersLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualRoutersRequest.ReadOnly =
    zio.aws.appmesh.model.ListVirtualRoutersRequest.wrap(buildAwsValue())
}
object ListVirtualRoutersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualRoutersRequest =
      zio.aws.appmesh.model.ListVirtualRoutersRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[ListVirtualRoutersLimit]
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def nextToken: Optional[String]
    def getLimit: ZIO[Any, AwsError, ListVirtualRoutersLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest
  ) extends zio.aws.appmesh.model.ListVirtualRoutersRequest.ReadOnly {
    override val limit: Optional[ListVirtualRoutersLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.appmesh.model.primitives.ListVirtualRoutersLimit(value)
        )
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest
  ): zio.aws.appmesh.model.ListVirtualRoutersRequest.ReadOnly = new Wrapper(
    impl
  )
}
