package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrpcGatewayRouteRewrite(
    hostname: Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteRewrite = {
    import GrpcGatewayRouteRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteRewrite
      .builder()
      .optionallyWith(hostname.map(value => value.buildAwsValue()))(_.hostname)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly =
    zio.aws.appmesh.model.GrpcGatewayRouteRewrite.wrap(buildAwsValue())
}
object GrpcGatewayRouteRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GrpcGatewayRouteRewrite =
      zio.aws.appmesh.model
        .GrpcGatewayRouteRewrite(hostname.map(value => value.asEditable))
    def hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly]
    def getHostname: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("hostname", hostname)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteRewrite
  ) extends zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly {
    override val hostname
        : Optional[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostname())
        .map(value =>
          zio.aws.appmesh.model.GatewayRouteHostnameRewrite.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteRewrite
  ): zio.aws.appmesh.model.GrpcGatewayRouteRewrite.ReadOnly = new Wrapper(impl)
}
