package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceDiscovery(
    awsCloudMap: Optional[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery] =
      Optional.Absent,
    dns: Optional[zio.aws.appmesh.model.DnsServiceDiscovery] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ServiceDiscovery = {
    import ServiceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
      .builder()
      .optionallyWith(awsCloudMap.map(value => value.buildAwsValue()))(
        _.awsCloudMap
      )
      .optionallyWith(dns.map(value => value.buildAwsValue()))(_.dns)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ServiceDiscovery.ReadOnly =
    zio.aws.appmesh.model.ServiceDiscovery.wrap(buildAwsValue())
}
object ServiceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ServiceDiscovery =
      zio.aws.appmesh.model.ServiceDiscovery(
        awsCloudMap.map(value => value.asEditable),
        dns.map(value => value.asEditable)
      )
    def awsCloudMap
        : Optional[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly]
    def dns: Optional[zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly]
    def getAwsCloudMap: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly
    ] = AwsError.unwrapOptionField("awsCloudMap", awsCloudMap)
    def getDns: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly
    ] = AwsError.unwrapOptionField("dns", dns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ) extends zio.aws.appmesh.model.ServiceDiscovery.ReadOnly {
    override val awsCloudMap
        : Optional[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsCloudMap())
        .map(value =>
          zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.wrap(value)
        )
    override val dns
        : Optional[zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dns())
        .map(value => zio.aws.appmesh.model.DnsServiceDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ): zio.aws.appmesh.model.ServiceDiscovery.ReadOnly = new Wrapper(impl)
}
