package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListVirtualNodesLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVirtualNodesRequest(
    limit: Optional[ListVirtualNodesLimit] = Optional.Absent,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest = {
    import ListVirtualNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListVirtualNodesLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly =
    zio.aws.appmesh.model.ListVirtualNodesRequest.wrap(buildAwsValue())
}
object ListVirtualNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualNodesRequest =
      zio.aws.appmesh.model.ListVirtualNodesRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[ListVirtualNodesLimit]
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def nextToken: Optional[String]
    def getLimit: ZIO[Any, AwsError, ListVirtualNodesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ) extends zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly {
    override val limit: Optional[ListVirtualNodesLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.appmesh.model.primitives.ListVirtualNodesLimit(value)
      )
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest
  ): zio.aws.appmesh.model.ListVirtualNodesRequest.ReadOnly = new Wrapper(impl)
}
